import { describe, expect, it } from 'vitest'
import { mount } from '@vue/test-utils'
import TodoList from '../TodoList.vue'

describe('TodoList.vue', () => {

  it('Par défaut, la liste des tâches est vide.', () => {
    const wrapper = mount(TodoList)

    expect(wrapper.findAll('li').length).toBe(0)
  })

  it('Par défaut, le nombre de tâches affiché est 0', () => {
    const wrapper = mount(TodoList)

    expect(wrapper.find('[role="counter"]').text()).toBe('0')
  })

  it("Le nombre de tâches doit s'afficher dans le bas de la liste.", async () => {
    const expectedNb = '3'
    const task1 = 'taskone'
    const task2 = 'tasktwo'
    const task3 = 'taskthree'
    const wrapper = mount(TodoList)
    const taskInputEl = wrapper.find('input[type="text"]') // Assure-toi que l'input a le bon sélecteur

    await taskInputEl.setValue(task1)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur
    await taskInputEl.setValue(task2)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur
    await taskInputEl.setValue(task3)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur

    expect(wrapper.find('[role="counter"]').text()).toBe(expectedNb)
  })



  it('Un clic sur la liste de tâches inverse son contenu.', async () => {
    const task1 = 'taskone'
    const task2 = 'tasktwo'
    const task3 = 'taskthree'
    const expectedTodos = "taskthree, tasktwo, taskone"
    const wrapper = mount(TodoList)
    const taskInputEl = wrapper.find('input[type="text"]') // Assure-toi que l'input a le bon sélecteur

    await taskInputEl.setValue(task1)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur
    await taskInputEl.setValue(task2)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur
    await taskInputEl.setValue(task3)
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur

    await wrapper.find('ul').trigger('click')
    const todosText = wrapper.findAll('li').map((li) => li.text()).join(', ');

    expect(todosText).toContain(expectedTodos)
  })

  it('On peut ajouter une tâche à la liste.', async () => {
    const wrapper = mount(TodoList)
    const newTask = 'task'
    const input = wrapper.find('input[type="text"]')
  
    await input.setValue(newTask) // Utilise setValue pour changer la valeur de l'input
    await wrapper.find('button').trigger('click') // Assure-toi que le bouton a le bon sélecteur
    
    expect(wrapper.findAll('li')[0].text()).toBe(newTask)
  })
})
