// @vitest-environment jsdom
import { describe, test, expect, afterAll, afterEach, beforeAll } from 'vitest'
import { setupServer } from 'msw/node'
import { success } from './mocks/handlers'
import { dogs } from './data/dogs.js'
import DogsService from '../src/services/dogsService'

const server = setupServer(...success)

beforeAll(() => server.listen({ onUnhandledRequest: 'error' }))
afterAll(() => server.close())
afterEach(() => server.resetHandlers())

describe('dogsService.js', () => {
  test("getDogs doit retourner l'ensemble des chiens", async () => {
    const dogsService = new DogsService()

    const response = await dogsService.getDogs()

    expect(dogs).toStrictEqual(response)
  })

  test('getDog doit retourner le chien associé au id', async () => {
    // TEST À FAIRE
  })
})
