import setText, { appendText } from './results.mjs'

// Async/await :
// Permet de travailler avec les promesse, mais plus simplement.

//         ______ async permet d'identifier qu'une fonction est asynchrone.
//        |
//        v
export async function get () {
  const { data } = await axios.get('http://localhost:3000/orders/1')
  //                 ^
  //                 |_______ await pause l'exécution et attend la promesse.
  //                          Doit être utilisé à l'intérieur d'une fonction async.
  //                          Bloque seulement à l'intérieur de la function.

  setText(JSON.stringify(data))
}

// Gestion des erreurs
export async function getCatch () {
  try {
    const { data } = await axios.get('http://localhost:3000/orders/123')
    setText(JSON.stringify(data))
  } catch (error) {
    setText(error)
  }
}

export async function chain () {
  //"axios.get" retourne un objet javascript (un objet "Promise").
  //Cet objet contient une propriété "data" qui elle contient la réponse du serveur (du json).
  //
  const { data } = await axios.get('http://localhost:3000/orders/1')
  //        ^
  //        |__ "{ data }" veut dire: prendre le contenu de la propriété "data" de l'objet retourné par axios, et la copier dans une variable nommée data.
  //            sans les { }, data contiendrait l'objet "Promise".
  //            On aurait pu aussi écrire { data: data } à la place de { data }
  //            Object destructuring: https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment#object_destructuring
  //
  //                _____La propriété "data" de la promesse est copié dans une variable nommée address
  //               |
  //               v
  const { data: address } = await axios.get(
    `http://localhost:3000/addresses/${data.shippingAddress}`
  )
  setText(`City: ${JSON.stringify(address.city)}`)
}

export async function concurrent () {
  const orderStatuses = axios.get('http://localhost:3000/orderStatuses')
  const orders = axios.get('http://localhost:3000/orders')

  setText('')

  const { data: statuses } = await orderStatuses
  const { data: order } = await orders

  appendText(JSON.stringify(statuses))
  appendText(JSON.stringify(order[0]))
}

//
// Pour aller plus loin...
// Voir explication de Promise.all dans le fichier 03-creating.mjs
export async function parallel () {
  setText('')
  await Promise.all([
    (async () => {
      const { data } = await axios.get('http://localhost:3000/orderStatuses')
      appendText(JSON.stringify(data))
    })(),
    (async () => {
      const { data } = await axios.get('http://localhost:3000/orders')
      appendText(JSON.stringify(data[0]))
    })()
  ])
}
