import setText from './results.mjs'

// L'objectif des deux fonctions ci-dessous est le même. Soit:
// - Afficher le status associé à une commande.
//
// La première méthode (raceCondition) ne donne pas le résultat voulu. Pourquoi ?
export function raceCondition () {
  let xhr = new XMLHttpRequest()
  let orderStatuses = []
  xhr.open('GET', 'http://localhost:3000/orderStatuses')
  xhr.onload = () => {
    orderStatuses = JSON.parse(xhr.responseText)
  }

  xhr.send()

  let xhr2 = new XMLHttpRequest()
  xhr2.open('GET', 'http://localhost:3000/orders/1')
  xhr2.onload = () => {
    const order = JSON.parse(xhr2.responseText)
    const description = orderStatuses.map(o => {
      if (o.id === order.orderStatusId) {
        return o.description
      }
    })[0]

    setText(`Order Status: ${description}`)
  }

  xhr2.send()
}

// Solution qui règle le problème ci-dessus, mais...
export function callbacks () {
  let xhr = new XMLHttpRequest()
  let orderStatuses = []
  xhr.open('GET', 'http://localhost:3000/orderStatuses')

  xhr.onload = () => {
    orderStatuses = JSON.parse(xhr.responseText)

    let xhr2 = new XMLHttpRequest()
    xhr2.open('GET', 'http://localhost:3000/orders/1')

    xhr2.onload = () => {
      const order = JSON.parse(xhr2.responseText)

      const description = orderStatuses.map(t => {
        if (t.id === order.orderStatusId) {
          return t.description
        }
      })[0]

      setText(`Order Status: ${description}`)
    }

    xhr2.send()
  }

  xhr.send()
}

// On veut éviter du code qui comme dans cet exemple.
//    1. Code difficile à maintenir, plusieurs dépendances
//    2. Comment gérer les erreurs ?
//
// Solution pour éviter : 02-creating

// xhr.onload = () => {
//   // ...
//   xhr2.onload = () => {
//     // ...code qui dépend de xhr
//     xhr3.onload = () => {
//       // ...code qui dépend de xhr2
//       xhr4.onload = () => {
//         // ...code qui dépend de xh3
//       };
//       xhr4.onerror = () => {
//         // ...gestion des erreurs de xhr4
//       };
//     };
//     xhr3.onerror = () => {
//       // ...gestion des erreurs de xhr3
//     };
//   };
//   xhr2.onerror = () => {
//     // ...gestion des erreurs de xhr2
//   };
// };
// xhr.onerror = () => {
//   // ...gestion des erreurs de xhr1
// };
